


export class FileUploadPopup {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0)" [onclick]="widget.close" class="fa fa-times-circle"></a>
				<a href="javascript:void(0);" [onclick]="widget.saveFile" class="fa fa-upload"></a>
			</div>
			<h1>Bestand uploaden</h1>
		</div>

		<form id="frmFile">
			<ez-file name="file" label="Bestand"></ez-file>
			
			<ez-text name="ref_description" label="Reference" [value]="file.refDescription"></ez-text>
			
			<ez-textarea name="note" label="Notitie" [value]="file.note"></ez-text>
		</form>
	`;
	
	isNew = true;
	
	
	file = {
		dbFileId:       null,
		refDescription: '',
		note:           ''
	};
	
	container = null;
	
	callback_close = null;
	
	setCallbackClose(c) { this.callback_close = c; }
	
	
	saveFile() {
		
		if (this.validate() > 0)
			return;
		
		
		let fd = new FormData();
		fd.append("file", $('#frmFile input[name=file]').get(0).files[0]);
		fd.append('a', 'save');
		fd.append('ref_description', $('#frmFile input[name=ref_description]').val());
		fd.append('note', $('#frmFile textarea[name=note]').val());
		
		
		showLoadingForm( '#frmFile' );
		fetch(appUrl('/service/files.do'), {
			method: 'POST',
			body: fd
		}).then(async function(e) {
			let json = await e.json();
			
			console.log( json );
			close_popup();
			
			reportUserMessage('Bestand geupload');
		}).catch( showErrorWidget );
		
		
//		close_popup();
	}
	
	validate() {
		$(this.container).find('span.error').text( '' );
		
		
		let errorCount = 0;
		
		let f = $('#frmFile input[name=file]');
		if (!f.val()) {
			$('#frmFile ez-file[name=file] span.error').text('verplicht');
			errorCount++;
		}
		
		
		
		return errorCount;
	}
	
	
	close() {
		close_popup();
	}
	
	show() {
		this.container = show_popup('Bestand uploaden', '');
		
		this.container.get(0).close_callback = function() {
			if ( this.callback_close )
				this.callback_close();
		}.bind(this);
		
		
		let ezTpl = new EzTemplate( this.container );
		ezTpl.loadHtml( this.tpl );
		
		ezTpl.setObject('widget', this);
		ezTpl.render();
		
	}
	
	
}

